<?php
/*
 * Copyright (c) 2014-2015 Aimy Extensions, Lingua-Systems Software GmbH
 *
 * http://www.aimy-extensions.com/
 *
 * License: GNU GPLv2, see LICENSE.txt within distribution and/or
 *          http://www.aimy-extensions.com/software-license.html
 */
 defined( '_JEXEC' ) or die(); require_once( JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_aimysitemap' . DIRECTORY_SEPARATOR . 'helpers' . DIRECTORY_SEPARATOR . 'config.php' ); require_once( JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_aimysitemap' . DIRECTORY_SEPARATOR . 'Uri.php' ); jimport( 'joomla.filesystem.file' ); class AimySitemapSitemap { static private $sitenames = array(); static private $jpagetitles = array(); const URL_UNCHANGED = 0; const URL_ADDED = 1; const URL_UPDATED = 2; public function add_or_update_url( $obj ) { $db = JFactory::getDbo(); $q = $db->getQuery( true ); $q->select( $db->quoteName( array( 'id', 'url', 'title', 'mtime', 'lock', 'lang' ) ) ) ->from( $db->quoteName( '#__aimysitemap' ) ) ->where( $db->quoteName( 'url' ) . ' = ' . $db->quote( $obj->url ) ) ->setLimit( 1 ); $db->setQuery( $q ); $obj_db = $db->loadObject(); if ( empty( $obj_db ) ) { $cfg = new AimySitemapConfigHelper(); if ( ! isset( $obj->priority ) ) { $obj->priority = $cfg->get( 'default_priority', 1.0 ); } if ( ! isset( $obj->state ) ) { $obj->state = $cfg->get( 'default_state', 1 ); } if ( ! isset( $obj->changefreq ) ) { $obj->changefreq = $cfg->get( 'default_changefreq', 'monthly' ); } $db->insertObject( '#__aimysitemap', $obj ); return self::URL_ADDED; } $upd = new JObject(); if ( isset( $obj->mtime ) and $obj->mtime > $obj_db->mtime ) { $upd->mtime = $obj->mtime; } $is_locked = ( isset( $obj_db->lock ) and $obj_db->lock ); if ( ! $is_locked and isset( $obj->title ) and $obj->title != $obj_db->title ) { $upd->title = $obj->title; } if ( ! $is_locked and isset( $obj->lang ) and $obj->lang != $obj_db->lang ) { $upd->lang = $obj->lang; } if ( isset( $upd->mtime ) or isset( $upd->title ) or isset( $upd->lang ) ) { $upd->id = $obj_db->id; $db->updateObject( '#__aimysitemap', $upd, 'id' ); return self::URL_UPDATED; } return self::URL_UNCHANGED; } public function rebuild() { $db = JFactory::getDbo(); $stats = array( 'added' => array(), 'updated' => array(), 'deleted' => array() ); $q = $db->getQuery( true ); $q->select( $db->quoteName( array( 'url', 'title', 'mtime', 'lang' ) ) ) ->from( $db->quoteName( '#__aimysitemap_crawl' ) ) ->where( $db->quoteName( 'index' ) . ' = 1' ); $db->setQuery( $q ); $urls = $db->loadObjectList(); foreach ( $urls as $obj ) { self::strip_sitename_from_title( $obj ); $rv = $this->add_or_update_url( $obj ); switch ( $rv ) { case self::URL_ADDED: $stats[ 'added' ][] = $obj->url; break; case self::URL_UPDATED: $stats[ 'updated' ][] = $obj->url; break; } } $q = $db->getQuery( true ); $q->select( $db->quoteName( array( 'id', 'url' ) ) ) ->from( '#__aimysitemap' ); $db->setQuery( $q ); $objs_db = $db->loadObjectList(); foreach ( $objs_db as $obj_db ) { $found = false; foreach ( $urls as $obj ) { if ( $obj_db->url == $obj->url ) { $found = true; break; } } if ( ! $found ) { $q = $db->getQuery( true ); $q->delete( '#__aimysitemap' ) ->where( $db->quoteName( 'id' ) . ' = ' . $db->quote( $obj_db->id ) ); $db->setQuery( $q ); $db->execute(); $stats[ 'deleted' ][] = $obj_db->url; } } return $stats; } public function write_sitemap_file() { require_once( JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_aimysitemap' . DIRECTORY_SEPARATOR . 'helpers' . DIRECTORY_SEPARATOR . 'message.php' ); $cfg = new AimySitemapConfigHelper(); $msg = new AimySitemapMessageHelper(); $rel_path = $cfg->get( 'xml_path' ); if ( empty( $rel_path ) ) { $msg->error( JText::_( 'AIMY_SM_MSG_XML_FILE_NOT_SET' ) ); return false; } $domain = null; $proto = null; $msg->notice( JText::sprintf( 'AIMY_SM_MSG_CANONICAL_COMBINE', 'http://www.aimy-extensions.com/combining-aimy-canonical-and-sitemap.html' ) ); if ( empty( $domain ) ) { $domain = self::get_current_domain(); } if ( empty( $proto ) ) { $proto = self::get_current_protocol(); } $db = JFactory::getDbo(); $q = $db->getQuery( true ); $q->select( $db->quoteName( array( 'url', 'priority', 'mtime', 'changefreq' ) ) ) ->from( $db->quoteName('#__aimysitemap' ) ) ->where( $db->quoteName( 'state' ) . '=' . '1' ); $db->setQuery( $q ); $rows = $db->loadObjectList(); $xml = array( '<?xml version="1.0" encoding="UTF-8"?>', '<urlset ' . 'xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' ); foreach ( $rows as $row ) { $u = new AimySitemapURI( $row->url ); $xml[] = sprintf( '<url>' . '<loc>%s://%s%s</loc>' . '%s' . '<changefreq>%s</changefreq>' . '<priority>%.1f</priority>' . '</url>', $proto, $domain, $u->getResourceHref(), $row->mtime ? sprintf( '<lastmod>%s</lastmod>', date( 'Y-m-d', $row->mtime ) ) : '', $row->changefreq, $row->priority ); } $xml[] = '</urlset>'; $full_path = JPATH_ROOT . '/' . $rel_path; $sitemap_xml = implode( "\n", $xml ); if ( JFile::write( $full_path, $sitemap_xml ) == false ) { $msg->error( JText::sprintf( 'AIMY_SM_MSG_XML_FILE_ERR_WRITE', $full_path ) ); return false; } $msg->message( JText::sprintf( 'AIMY_SM_MSG_XML_FILE_UPDATED', $rel_path ) ); return true; } public static function unlink_file_if_exists() { require_once( JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_aimysitemap' . DIRECTORY_SEPARATOR . 'helpers' . DIRECTORY_SEPARATOR . 'message.php' ); $cfg = new AimySitemapConfigHelper(); $msg = new AimySitemapMessageHelper(); $rel_path = $cfg->get( 'xml_path' ); if ( empty( $rel_path ) ) { return false; } $full_path = JPATH_ROOT . '/' . $rel_path; if ( ! JFile::exists( $full_path ) ) { return false; } if ( JFile::delete( $full_path ) === true ) { $msg->message( JText::_( 'AIMY_SM_MSG_XML_FILE_REMOVED' ) ); return true; } $msg->error( JText::_( 'AIMY_SM_MSG_XML_FILE_ERR_REMOVE' ) ); return false; } static private function initialize_sitename_list() { $app = JFactory::getApplication(); $db = JFactory::getDbo(); $sn = trim( $app->getCfg( 'sitename', '' ) ); if ( ! empty( $sn ) ) { self::$sitenames[] = $sn; } try { $q = $db->getQuery( true ); $q->select( $db->quoteName( 'sitename' ) ) ->from( $db->quoteName( '#__languages' ) ) ->where( $db->quoteName( 'published' ) . '=' . '1' ); $db->setQuery( $q ); $rows = $db->loadObjectList(); foreach ( $rows as $row ) { $sn = trim( $row->sitename ); if ( ! empty( $sn ) ) { self::$sitenames[] = $sn; } } } catch ( Exception $e ) { } } static private function initialize_jpagetitle_list() { $jlang = JFactory::getLanguage(); $db = JFactory::getDbo(); $langs = $jlang->getKnownLanguages(); $jpts = array(); foreach ( array_keys( $langs ) as $lang ) { $over_path = JPATH_SITE . DIRECTORY_SEPARATOR . 'language' . DIRECTORY_SEPARATOR . 'overrides' . DIRECTORY_SEPARATOR . "$lang.override.ini"; if ( JFile::exists( $over_path ) ) { $cnt = @file_get_contents( $over_path ); if ( $cnt !== false ) { $cnt = str_replace( '_QQ_', '"\""', $cnt ); $ors = @parse_ini_string( $cnt ); if ( is_array( $ors ) ) { if ( isset( $ors[ 'JPAGETITLE' ] ) && ! empty( $ors[ 'JPAGETITLE' ] ) ) { $jpts[ $ors[ 'JPAGETITLE' ] ] = 1; continue; } } } } $jo = JLanguage::getInstance( $lang ); if ( $jo->load( 'joomla', JPATH_SITE ) ) { $jpt = $jo->_( 'JPAGETITLE' ); if ( ! empty( $jpt ) ) { $jpts[ $jpt ] = 1; } } } if ( empty( $jpts ) ) { $jpts[ '%1$s - %2$s' ] = 1; } self::$jpagetitles = array_keys( $jpts ); } static private function strip_sitename_from_title( &$obj ) { if ( ! isset( $obj->title ) or empty( $obj->title ) ) { return; } $app = JFactory::getApplication(); $pos = (int) $app->getCfg( 'sitename_pagetitles', 0 ); if ( empty( $pos ) ) { return; } if ( empty( self::$sitenames ) or empty( self::$jpagetitles ) ) { self::initialize_sitename_list(); self::initialize_jpagetitle_list(); } $title = ''; $mark = '@MARK@'; switch ( $pos ) { case 1: foreach ( self::$sitenames as $sn ) { foreach ( self::$jpagetitles as $jpt ) { $mtitle = sprintf( $jpt, $sn, $mark ); $mpos = strpos( $mtitle, $mark ); if ( $mpos === false ) { continue; } $prefix = substr( $mtitle, 0, $mpos ); if ( strpos( $obj->title, $prefix ) === 0 ) { $title = substr( $obj->title, strlen( $prefix ) ); break; } } if ( ! empty( $title ) ) { break; } } break; case 2: $title_len = strlen( $obj->title ); foreach ( self::$sitenames as $sn ) { foreach ( self::$jpagetitles as $jpt ) { $mtitle = sprintf( $jpt, $mark, $sn ); $mpos = strpos( $mtitle, $mark ); if ( $mpos === false ) { continue; } $suffix = substr( $mtitle, $mpos + strlen( $mark ) ); $suffix_len = strlen( $suffix ); if ( $suffix_len > $title_len ) { continue; } $diff = substr_compare( $obj->title, $suffix, $title_len - $suffix_len, $suffix_len ); if ( $diff === 0 ) { $title = substr( $obj->title, 0, $title_len - $suffix_len ); break; } } if ( ! empty( $title ) ) { break; } } break; } if ( ! empty( $title ) ) { $obj->title = trim( $title ); } } static private function get_current_domain() { $u = new JURI( JURI::root() ); return $u->getHost(); } static private function get_current_protocol() { $u = new JURI( JURI::root() ); return $u->getScheme(); } } 
