﻿


jQuery(function() {
	// Get the form.
	var form = jQuery('#ajax-contact');
    
	// Get the messages div.
	var formMessages = jQuery('#form-messages');
    
	// Set up an event listener for the contact form.
	jQuery(form).submit(function(e) {
		// Stop the browser from submitting the form.
		e.preventDefault();
        
		// Serialize the form data.
		var formData = jQuery(form).serialize();
        
		// Submit the form using AJAX.
		jQuery.ajax({
			type: 'POST',
			//url: $(form).attr('action'),
            url: "mailer.php",
			data: formData
		})
    
		.done(function(response) {
			// Make sure that the formMessages div has the 'success' class.
			jQuery(formMessages).removeClass('error');
			jQuery(formMessages).addClass('success');
            
			// Set the message text.
			jQuery(formMessages).text(response);
			// Clear the form.
			jQuery('#name').val('Your name');
			jQuery('#email').val('Your email');
			jQuery('#message').val('Message');
              jQuery('#lettersubject').val('Subject');
		})
		.fail(function(data) {
			// Make sure that the formMessages div has the 'error' class.
			jQuery(formMessages).removeClass('success');
			jQuery(formMessages).addClass('error');
			// Set the message text.
			if (data.responseText !== '') {
				jQuery(formMessages).text(data.responseText);
			} else {
				jQuery(formMessages).text('Thank youJS.');
			}
		});
	});
});
