CREATE TABLE IF NOT EXISTS `#__tagmeta_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL DEFAULT '',
  `case_sensitive` tinyint(1) NOT NULL DEFAULT '1',
  `request_only` tinyint(1) NOT NULL DEFAULT '1',
  `decode_url` tinyint(1) NOT NULL DEFAULT '1',
  `last_rule` tinyint(1) NOT NULL DEFAULT '1',
  `placeholders` text NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `rights` varchar(255) DEFAULT NULL,
  `xreference` varchar(255) DEFAULT NULL,
  `canonical` varchar(255) DEFAULT NULL,
  `custom_header` text NOT NULL,
  `rindex` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0=No,1=Yes,2=Skip',
  `rfollow` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0=No,1=Yes,2=Skip',
  `rsnippet` tinyint(1) NOT NULL DEFAULT '2' COMMENT '0=No,1=Yes,2=Skip',
  `rarchive` tinyint(1) NOT NULL DEFAULT '2' COMMENT '0=No,1=Yes,2=Skip',
  `rodp` tinyint(1) NOT NULL DEFAULT '2' COMMENT '0=No,1=Yes,2=Skip',
  `rydir` tinyint(1) NOT NULL DEFAULT '2' COMMENT '0=No,1=Yes,2=Skip',
  `rimageindex` tinyint(1) NOT NULL DEFAULT '2' COMMENT '0=No,1=Yes,2=Skip',
  `comment` varchar(255) DEFAULT NULL,
  `synonyms` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0=No,1=Yes,2=Yes (case sensitive)',
  `synonmax` int(11) unsigned NOT NULL DEFAULT '0' COMMENT 'Max number of synonyms to add',
  `synonweight` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0=Use ordering,1=Use weight',
  `preserve_title` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0=No,1=Yes',
  `hits` int(11) unsigned NOT NULL DEFAULT '0',
  `last_visit` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idxurl` (`url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__tagmeta_synonyms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `keywords` varchar(500) NOT NULL DEFAULT '',
  `synonyms` varchar(500) DEFAULT NULL,
  `weight` int(11) NOT NULL DEFAULT '0',
  `comment` varchar(255) DEFAULT NULL,
  `hits` int(11) unsigned NOT NULL DEFAULT '0',
  `last_visit` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
