<?php
/*
 * Copyright (c) 2014-2015 Aimy Extensions, Lingua-Systems Software GmbH
 *
 * http://www.aimy-extensions.com/
 *
 * License: GNU GPLv2, see LICENSE.txt within distribution and/or
 *          http://www.aimy-extensions.com/software-license.html
 */
 defined( '_JEXEC' ) or die(); jimport( 'joomla.filesystem.file' ); class AimySitemapRobotsTxt { private $rules = null; private $txt = null; const ALLOW = true; const DISALLOW = false; public function __construct( $txt = null ) { $this->rules = array(); if ( empty( $txt ) ) { $this->txt = self::get_from_file(); if ( is_null( $this->txt ) ) { $this->txt = self::get_via_http(); } } else { $this->txt = $txt; } if ( is_null( $this->txt ) ) { $this->txt = ''; } $this->rules = self::parse( $this->txt ); } public function get_txt() { return $this->txt; } public function disallowed( $url ) { if ( empty( $this->rules ) ) { return false; } foreach ( $this->rules as $r ) { if ( strpos( $url, $r[ 'path' ] ) === 0 ) { return ( $r[ 'action' ] == self::DISALLOW ); } } return false; } public function allowed( $url ) { return (! $this->disallowed( $url )); } static private function get_from_file() { if ( JURI::root( true ) !== '/' ) { return null; } $path = JPATH_ROOT . '/robots.txt'; if ( JFile::exists( $path ) ) { $txt = file_get_contents( $path ); if ( $robots_txt !== false ) { AimySitemapLogger::debug( 'Crawl-Init: Got robots.txt from filesystem' ); } return $txt; } return null; } static private function get_via_http() { require_once( JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_aimysitemap' . DIRECTORY_SEPARATOR . 'HttpClient.php' ); try { $u = new AimySitemapURI( JURI::root() ); $u->setPath( '/robots.txt' ); $r = AimySitemapHttpClient::get_url( $u ); if ( is_array( $r ) && $r[ 'head' ][ 'code' ] == 200 ) { return $r[ 'body' ]; } } catch ( Exception $e ) { } return null; } static private function sort_desc_by_length( $a, $b ) { return strlen( $b[ 'path' ] ) - strlen( $a[ 'path' ] ); } static private function parse( $txt ) { $ls = preg_split( '/\r?\n/', $txt ); $apply = false; $rules = array(); foreach ( $ls as $l ) { $l = trim( $l ); if ( empty( $l ) or strpos( $l, '#' ) === 0 ) { continue; } if ( strpos( $l, ':' ) === false ) { throw new RuntimeException( 'Invalid robots.txt entry found: [' . $l . ']' ); } list( $op, $val ) = explode( ':', $l, 2 ); switch ( $op ) { case 'User-agent': case 'User-Agent': case 'user-agent': $apply = (( strpos( $val, '*' ) !== false ) or ( strpos( $val, 'AimySitemapCrawler' ) !== false )); break; case 'Disallow': case 'disallow': if ( $apply ) { $val = trim( $val ); if ( empty( $val ) ) { $rules = array(); } else { $rules[] = array( 'path' => $val, 'action' => self::DISALLOW ); } } break; case 'Allow': case 'allow': if ( $apply ) { $val = trim( $val ); if ( ! empty( $val ) ) { $rules[] = array( 'path' => $val, 'action' => self::ALLOW ); } } break; case 'Crawl-delay': case 'crawl-delay': case 'Sitemap': case 'sitemap': case 'Host': case 'host': break; default: throw new RuntimeException( 'Invalid robots.txt entry found: [' . $l . ']' ); } } usort( $rules, 'self::sort_desc_by_length' ); return $rules; } } 
